/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.setCovering;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SetCovering
implements Serializable {
    private static final long serialVersionUID = -4580626902003828381L;
    private ArrayList<Set> mSets;
    private ArrayList<Element> mElements = new ArrayList();
    private ArrayList<Integer> mSolution;

    public SetCovering(int numSets) {
        this.mSets = new ArrayList(numSets);
        this.mSolution = new ArrayList(numSets);
        int i = 0;
        while (i < numSets) {
            this.mSets.add(new Set(i));
            ++i;
        }
    }

    public void addElement(ArrayList<Integer> sets) {
        if (sets.size() == 0) {
            return;
        }
        Element e = new Element(this.mElements.size(), sets.size());
        this.mElements.add(e);
        for (Integer s : sets) {
            e.addSet(this.mSets.get(s));
        }
        for (Integer s : sets) {
            this.mSets.get(s).addElement(e);
        }
    }

    public void solve(int k) {
        HashMap<Integer, Integer> notCovereds = new HashMap<Integer, Integer>();
        int[] coveringCounter = new int[this.mElements.size()];
        for (Element e : this.mElements) {
            notCovereds.put(e.mName, e.mName);
        }
        for (Element elemento : this.mElements) {
            if (elemento.numSets() != 1) continue;
            for (Set c : elemento.mSets.values()) {
                if (c.mElements.size() != 0) {
                    this.mSolution.add(c.mName);
                    for (Element element : c.getElementos()) {
                        element.autoKill();
                        notCovereds.remove(element.mName);
                    }
                }
                this.mSets.remove(c);
            }
        }
        while (notCovereds.size() > 0 && this.mSets.size() > 0) {
            Set bestSet = null;
            double bestCost = -1.0;
            for (Set conj : this.mSets) {
                double aux = conj.mCost / (double)conj.getSize();
                if (!(aux < bestCost) && bestSet != null) continue;
                bestSet = conj;
                bestCost = aux;
            }
            if (bestSet != null) {
                this.mSolution.add(bestSet.mName);
                for (Element e : bestSet.getElementos()) {
                    int nome;
                    int n = nome = e.mName;
                    coveringCounter[n] = coveringCounter[n] + 1;
                    if (coveringCounter[nome] != k) continue;
                    e.autoKill();
                    notCovereds.remove(nome);
                }
                this.mSets.remove(bestSet);
                Iterator<Set> it = this.mSets.iterator();
                while (it.hasNext()) {
                    Set set = it.next();
                    if (set.getSize() != 0) continue;
                    it.remove();
                }
                continue;
            }
            this.mSolution.clear();
            this.clear();
            return;
        }
        this.clear();
    }

    public ArrayList<Integer> getSolution() {
        return this.mSolution;
    }

    public void write(String fileName) {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(fileName));
            writer.println("Min Z = ");
            boolean fist = true;
            for (Set c : this.mSets) {
                if (fist) {
                    writer.print(" x" + c.mName);
                    fist = false;
                    continue;
                }
                writer.print(" + x" + c.mName);
            }
            writer.println("\nsubject to:");
            fist = true;
            for (Element e : this.mElements) {
                for (Set c : e.getSets()) {
                    if (fist) {
                        writer.print("x" + c.mName);
                        fist = false;
                        continue;
                    }
                    writer.print(" + x" + c.mName);
                }
                writer.println(" >= 1");
            }
            writer.print("Binary ");
            for (Set c : this.mSets) {
                writer.print(" x" + c.mName);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.mElements.clear();
        this.mSets.clear();
        System.gc();
    }

    private class Element
    implements Comparable<Element> {
        private HashMap<Set, Set> mSets;
        private int mName;

        public Element(int name, int numSets) {
            this.mSets = new HashMap(numSets);
            this.mName = name;
        }

        public int numSets() {
            return this.mSets.size();
        }

        public ArrayList<Set> getSets() {
            return new ArrayList<Set>(this.mSets.values());
        }

        public void addSet(Set c) {
            this.mSets.put(c, c);
        }

        public void autoKill() {
            for (Set c : this.mSets.values()) {
                c.removeElement(this);
            }
        }

        @Override
        public int compareTo(Element e) {
            if (this.mName > e.mName) {
                return -1;
            }
            if (this.mName < e.mName) {
                return 1;
            }
            return 0;
        }
    }

    private class Set
    implements Comparable<Set> {
        private HashMap<Element, Element> mElements = new HashMap();
        private double mCost = 1.0;
        private int mName;

        public Set(int nome) {
            this.mName = nome;
        }

        public ArrayList<Element> getElementos() {
            return new ArrayList<Element>(this.mElements.values());
        }

        public int getSize() {
            return this.mElements.size();
        }

        public void addElement(Element e) {
            if (e != null) {
                this.mElements.put(e, e);
                e.addSet(this);
            }
        }

        public void removeElement(Element e) {
            this.mElements.remove(e);
        }

        @Override
        public int compareTo(Set s) {
            if (this.mName > s.mName) {
                return -1;
            }
            if (this.mName < s.mName) {
                return 1;
            }
            return 0;
        }
    }
}

